/*
Copyright (c) 2003, Michel Jean-Franois <jfmichel(at)operamail(dot)com>
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer. 

- 	Redistributions in binary form must reproduce the above copyright 
	notice, this list of conditions and the following disclaimer in the 
	documentation and/or other materials provided with the distribution. 

-	Neither the name of Sobek nor the names of its contributors 
	may be used to endorse or promote products derived from this software 
	without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
*/
#ifndef __INS_HPP
#define __INS_HPP

#include "options.hpp"
//--------------------------------------------------------------------------

// dfinition ajoutes pour le DFA

// copied et changed vont de paire
// si une oprande est 'copied' elle est copi dans les 'changed'

#define DF_DESTR1      0x00020000		// dtruit op 1
#define DF_DESTR2      0x00040000		// dtruit op 2
#define DF_DESTR3      0x00080000		// dtruit op 3
#define DF_DESTR4      0x00100000		// dtruit op 4

#define DF_CPY1	       0x00200000		// copie de op 1
#define DF_CPY2        0x00400000 	// copie de op 2
#define DF_CPY3	       0x00800000		// copie de op 3
#define DF_CPY4        0x01000000 	// copie de op 4

#define DF_ALIAS1      0x02000000		// alias de op 1
#define DF_ALIAS2      0x04000000		// alias de op 2
#define DF_ALIAS3      0x08000000		// alias de op 1
#define DF_ALIAS4      0x10000000		// alias de op 2

#define DF_STACK       0x20000000   // utilise une oprande de pile

//--------------------------------------------------------------------------

extern instruc_t ins[];

//--------------------------------------------------------------------------

bool Ins_Op_Test (ulong flag);
bool Op_Is_Destroyed(int opnum);
bool Op_Is_Copied(int opnum);
bool Op_Is_Aliased(int opnum);
bool Op_Is_Changed(int opnum);
bool Op_Is_Used(int opnum);
int get_nb_op();


#endif
