/*
Copyright (c) 2003, Michel Jean-Franois <jfmichel(at)operamail(dot)com>
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer. 

- 	Redistributions in binary form must reproduce the above copyright 
	notice, this list of conditions and the following disclaimer in the 
	documentation and/or other materials provided with the distribution. 

-	Neither the name of Sobek nor the names of its contributors 
	may be used to endorse or promote products derived from this software 
	without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
*/

#ifndef __global_ana_hpp
#define __global_ana_hpp

#include <ida.hpp>
#include <idp.hpp>
#include <list>

#include "options.hpp"
#include "basic_ana.hpp"

// mode disponible pour la fonction global_trace
#define TRACE_FORWARD   0
#define TRACE_BACKWARD  1

// liste de netnodes
typedef list<netnode> liste_node;

//--------------------------------------------------------------------------

struct basic_block
{
  ea_t ea;
  liste_ptrop* in;
  unsigned char flag;
  // prev_ea sert pour les CALL sur des tables
  // la ret_addr seule ne nous donne pas assez d'informations pour savoir
  // de quel bloc vient
  ea_t prev_ea;
  liste_ret ret_addr;
  int depth;

  // constructeur
  basic_block(ea_t _ea,
              liste_ptrop* _in,
              unsigned char _flag,
              ea_t _prev_ea,
              liste_ret _ret_addr,
              int _depth)
  :ea(_ea), in(_in), flag(_flag), prev_ea(_prev_ea),ret_addr(_ret_addr),
   depth(_depth) {};

  // oprateur d'galit
  // teste les liste_ptrop au point de vue de leur adresse
  // et pas des oprandes contenues

  bool operator== (const basic_block& block)
  {
    return (    (ea == block.ea)
             && (in == block.in)
             && (flag == block.flag)
             && (prev_ea == block.prev_ea) );
  }

};

// liste de blocs de base
typedef list<basic_block> liste_bb;

//--------------------------------------------------------------------------

namespace global_ana
{
  void set_depth_limit(int,int); // tablit les limites de profondeur
  bool check_depth_limit(int); // teste si la profondeur passe en paramtre
  void add_limits(area_t); // ajoute une limite d'adresses
  bool check_limit(ea_t); // teste les limites d'adresses

  // effectue une analyse de flux de donnes
  liste_node* global_trace(ea_t, df_op_t*, int);
};

#endif
