/*
Copyright (c) 2003, Michel Jean-Franois <jfmichel(at)operamail(dot)com>
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer. 

- 	Redistributions in binary form must reproduce the above copyright 
	notice, this list of conditions and the following disclaimer in the 
	documentation and/or other materials provided with the distribution. 

-	Neither the name of Sobek nor the names of its contributors 
	may be used to endorse or promote products derived from this software 
	without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
*/

#ifndef __basic_ana
#define __basic_ana

#include <ida.hpp>
#include <idp.hpp>
#include <netnode.hpp>
#include <list>

#include "options.hpp"
#include "ins.hpp"
#include "operandes.hpp"

//--------------------------------------------------------------------------
// flags de transitions
//--------------------------------------------------------------------------

#define NEXT_JMP        0
#define NEXT_CALL       1
#define NEXT_FALSE_CALL 2 // appel de fonction ignore
#define NEXT_RET        3

//--------------------------------------------------------------------------
// ret : une adresse de retour
//--------------------------------------------------------------------------
struct ret
{
  ea_t ea;
  int depth;
  ret(ea_t _ea, int _depth): ea(_ea), depth(_depth) {}
  ret(void) : ea(BADADDR), depth(0) {}
};

//--------------------------------------------------------------------------
// liste_ret : pile des adresses de retour
//--------------------------------------------------------------------------
typedef list<ret> liste_ret;

//--------------------------------------------------------------------------
namespace basic_ana
{

  extern uint options; // options d'analyse

  void set_option(uint); // dfinit une option

  // cre la liste des dpendences de l'oprande dans la liste l
  void add_to_dependence_list(df_op_t* op, liste_ptrop& l);

  // efface les oprandes de l et les retire de out
  void delete_list(liste_ptrop &out, liste_ptrop& l);

  // dtecte la fin d'un bloc de base
  bool is_basic_block_end(ea_t genEA, bool backward = false);

  // effectue un traage avant
  void trace_forward(/*IN*/ ea_t ea,
                     /*IN*/ const liste_ptrop& in,
                     /*OUT*/ liste_ptrop& out,
                     /*OUT*/ list<ea_t>& next,
                     /*OUT*/ netnode res,
                     /*IN/OUT*/liste_ret& callstate,
                     /*IN/OUT*/ unsigned char& flag,
                     /*IN/OUT*/ ea_t& prev_ea,
                     /*IN/OUT*/ int& depth);

  // effectue un traage arrire
  void trace_backward(/*IN*/ ea_t ea,
                      /*IN*/ const liste_ptrop& in,
                      /*OUT*/ liste_ptrop& out,
                      /*OUT*/ list<ea_t>& next,
                      /*OUT*/ netnode res,
                      /*IN/OUT*/liste_ret& callstate,
                      /*IN/OUT*/ unsigned char& flag,
                      /*IN/OUT*/ ea_t& prev_ea,
                      /*IN/OUT*/ int& depth);

  // duplique la liste in dans la liste out et conserve la structure des alias
  void duplicate_and_append(const liste_ptrop &in, liste_ptrop &out);

  // ajoute dans 'liste' toutes les adresses des instruction de retour
  // de fonction de la fonction en ea
  void getRetFromFunc(ea_t ea, list<ea_t>& liste);

  // renvoie la liste des adresses de retour de l'appel de la fonction en ea
  void getRetAddr(/*IN*/ea_t ea, /*OUT*/list<ea_t>& liste);
}
#endif
